// WatkiKoligacjeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WatkiKoligacje.h"
#include "WatkiKoligacjeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CWatkiKoligacjeDlg dialog




CWatkiKoligacjeDlg::CWatkiKoligacjeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWatkiKoligacjeDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWatkiKoligacjeDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_LIST1, ListBox1);
}

BEGIN_MESSAGE_MAP(CWatkiKoligacjeDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_BN_CLICKED(IDC_BUTTON1, &CWatkiKoligacjeDlg::OnBnClickedButton1)
    ON_BN_CLICKED(IDC_BUTTON2, &CWatkiKoligacjeDlg::OnBnClickedButton2)
    ON_BN_CLICKED(IDC_BUTTON3, &CWatkiKoligacjeDlg::OnBnClickedButton3)
    ON_BN_CLICKED(IDC_BUTTON4, &CWatkiKoligacjeDlg::OnBnClickedButton4)
END_MESSAGE_MAP()


// CWatkiKoligacjeDlg message handlers

BOOL CWatkiKoligacjeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
    GetSystemInfo(&sysInfo);
    aktualnyProcesor = 1;
    
    CString temp;
    for(UINT i = 1; i <= sysInfo.dwNumberOfProcessors; i++)
    {
        temp.Format(L"CPU nr %d", i);
        ListBox1.AddString(temp);
    }

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWatkiKoligacjeDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWatkiKoligacjeDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CWatkiKoligacjeDlg::OnBnClickedButton1()
{
    CString temp;
    temp.Format(L"Ilo procesorw w twoim komputerze = %d", 
        sysInfo.dwNumberOfProcessors);
    AfxMessageBox(temp);
}

void CWatkiKoligacjeDlg::OnBnClickedButton2()
{
    int iloscProcesorow = sysInfo.dwNumberOfProcessors;
    DWORD numerProcesora;
    CString temp;

    if(aktualnyProcesor >= iloscProcesorow)
        aktualnyProcesor = 1;
    else
        aktualnyProcesor++;
    
    numerProcesora = 1 << (aktualnyProcesor-1);

    if(!SetProcessAffinityMask(GetCurrentProcess(), numerProcesora))
    {
        DWORD errorCode = GetLastError();	
        temp.Format(L"Nie udao si przypisa aktualnego procesu do procesora nr %d\nKod bdu: %d", aktualnyProcesor, errorCode);
        AfxMessageBox(temp);
    }
    else
    {
        temp.Format(L"Pomylnie przypisano biecy proces do procesora nr %d", aktualnyProcesor);
        AfxMessageBox(temp);
    }
}

void CWatkiKoligacjeDlg::OnBnClickedButton3()
{
	DWORD dwProcessAffinityMask, dwSystemAffinityMask;
	CString temp;

	GetProcessAffinityMask(GetCurrentProcess(), 
		&dwProcessAffinityMask,
		&dwSystemAffinityMask);

	temp.Format(L"Maska koligacji dla aktualnego procesu: %d\nMaska koligacji dla systemu: %d", 
		dwProcessAffinityMask, dwSystemAffinityMask);

	AfxMessageBox(temp);
}

void CWatkiKoligacjeDlg::OnLbnDblclkList1()
{
    DWORD procesorWatku = 1 << ListBox1.GetCurSel();
    CString temp;
    
    if(!SetThreadAffinityMask(GetCurrentThread(), procesorWatku))
    {
        temp.Format(L"Nie udao si przypisa biecego wtku do procesora: %d\nKod bdu: %d", procesorWatku, GetLastError());    
        AfxMessageBox(temp);
    }
    else
    {
        temp.Format(L"Pomylnie przypisano wtek do procesora: %d", procesorWatku);
        AfxMessageBox(temp);
    }        
}

void CWatkiKoligacjeDlg::OnBnClickedButton4()
{
    DWORD idealnyProcesorDlaWatku = ListBox1.GetCurSel() + 1;
    DWORD errorCode;
    CString temp;
    
    SetThreadIdealProcessor(GetCurrentThread(), idealnyProcesorDlaWatku);
    errorCode = GetLastError();
    
    if(errorCode)
    {
        temp.Format(L"Bd! Kod bdu: %d", errorCode); 
        AfxMessageBox(temp);
    }
    else
        AfxMessageBox(L"Wykonano poprawnie");
}
